//
//  BPCloudSignUpWindow.h
//  BIViews
//
//  Created by Brent Gulanowski on 11-01-27.
//  Copyright 2011 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <BPViews/BPAbstractLoginWindow.h>
#import <MCNetComm/MCHostMonitor.h>


@class BPCloudTerms, BIPageControl, MCRestRequest, MCHostMonitor;
@class BPCloudSignUpDetails, BPCloudSignUpWorkers, BPCloudSignUpIdentity, BPCloudSignUpRates, BPCloudSignUpTaxes, BPWelcomeView;
@class BPCloudNoInternetAlert;

/*
 Change: In order to support freemium, we are removing the workers pane
 */

@interface BPCloudSignUpWindow : BPAbstractLoginWindow<MCHostMonitorDelegate, NSWindowDelegate> {

	BPCloudTerms *termsWC;
	BIPageControl *pageControl;
	
	MCRestRequest *signUpRequest;
	MCRestRequest *inviteRequest;
	MCHostMonitor *hostMonitor;
	
	NSTabView *tabView;
	NSButton *backButton;
	NSButton *forwardButton;
		
	BPCloudSignUpDetails *detailsVC;
	BPCloudSignUpWorkers *workersVC;
	BPCloudSignUpIdentity *identityVC;
	BPCloudSignUpRates *ratesVC;
	BPCloudSignUpTaxes *taxesVC;
	BPWelcomeView *welcomeVC;
	
	BPCloudNoInternetAlert *noInternetWC;
	
	NSArray *viewControllers;
	
	NSUInteger selectionIndex;
	NSUInteger alertReturnCode;
	BOOL hasInternetAccess;
	BOOL creatingAccount;
	BOOL accountCreated;
}

@property (nonatomic, retain) MCHostMonitor *hostMonitor;

@property (nonatomic, assign) IBOutlet BIPageControl *pageControl;
@property (nonatomic, assign) IBOutlet NSTabView *tabView;
@property (nonatomic, assign) IBOutlet NSButton *backButton;
@property (nonatomic, assign) IBOutlet NSButton *forwardButton;

@property (nonatomic, retain) BPCloudSignUpDetails *detailsVC;
@property (nonatomic, retain) BPCloudSignUpWorkers *workersVC;
@property (nonatomic, retain) BPCloudSignUpIdentity *identityVC;
@property (nonatomic, retain) BPCloudSignUpRates *ratesVC;
@property (nonatomic, retain) BPCloudSignUpTaxes *taxesVC;
@property (nonatomic, retain) BPWelcomeView *welcomeVC;

@property (nonatomic) NSUInteger selectionIndex;
@property (nonatomic) BOOL hasInternetAccess;
@property (nonatomic) BOOL creatingAccount;

@property (readonly) NSString *title;
@property (readonly) NSString *forwardButtonTitle;
@property (readonly) BOOL canGoBack;
@property (readonly) BOOL canGoForward;
@property (readonly) BOOL enableForward;

@property (readonly) BOOL showPageControl;
@property (readonly, getter=isFinishedSetup) BOOL finishedSetup;
@property (readonly) NSUInteger pageControlIndex;

- (void)configureCurrentView;
- (void)requestSendUserInvitations;

- (IBAction)backward:(id)sender;
- (IBAction)forward:(id)sender;

- (IBAction)showTerms:(id)sender;

@end
